/*******************************************************************/
/*                                                                 */
/*                      ADOBE CONFIDENTIAL                         */
/*                   _ _ _ _ _ _ _ _ _ _ _ _ _                     */
/*                                                                 */
/* Copyright 1986 - 2000 Adobe Systems Incorporated                */
/* All Rights Reserved.                                            */
/*                                                                 */
/* NOTICE:  All information contained herein is, and remains the   */
/* property of Adobe Systems Incorporated and its suppliers, if    */
/* any.  The intellectual and technical concepts contained         */
/* herein are proprietary to Adobe Systems Incorporated and its    */
/* suppliers and may be covered by U.S. and Foreign Patents,       */
/* patents in process, and are protected by trade secret or        */
/* copyright law.  Dissemination of this information or            */
/* reproduction of this material is strictly forbidden unless      */
/* prior written permission is obtained from Adobe Systems         */
/* Incorporated.                                                   */
/*                                                                 */
/*******************************************************************/
//-------------------------------------------------------------------
/*
 * Name:
 *	PIProgressSuite.h
 *
 * Copyright 1986-2000 Adobe Systems Incorporated.
 * All Rights Reserved.
 *
 * Purpose:
 *	Define the Plug-in Progress Suite. 
 *
 * Distribution:
 *	PUBLIC
 *
 * Version history:
 *	1.0.0 4/1/1998	Ace	First Version.
 *		Created by Andy Coven.
 */



#ifndef __PIProgressSuite__
#define __PIProgressSuite__

#include "PIGeneral.h"
// NOTE (SRP) : ASZStringSuite.h has a dependency on size_t. Not good for C++
// where this is included in the standard as std::size_t.

#if defined(__cplusplus) && !defined(size_t)

#include <cstddef>
#define size_t std::size_t
#include "ASZStringSuite.h"
#undef size_t

#else
#include "ASZStringSuite.h"
#endif

#ifdef __cplusplus
extern "C" {
#endif

/******************************************************************************/

#define kPSProgressSuite 			"Photoshop Progress Suite for Plug-ins"


//-------------------------------------------------------------------------
//	Progress suite typedefs 
//-------------------------------------------------------------------------


typedef SPErr (*Progress_DoProgress) (const ASZString zs, SPErr (*proc) (void *), void *refCon);


// Section off a portion of the unused progress bar for execution of a subtask.
// taskLength should be between 0.0 and 1.0. This routine returns the
// errorcode from proc.

typedef SPErr (*Progress_DoTask) (double taskLength, SPErr (*proc) (void *), void *refCon);


// Limit progress to a section of the progress bar based on executing
// segmentLength out of total steps. done is a counter of how much we've
// accomplished so far and will be incremented by segmentLength if the task
// succeeds. (We need done because as with DoTask, what we care about is
// the percentage of the remaining progress bar.)

typedef SPErr (*Progress_DoSegmentTask) (int32 segmentLength,
										 int32 *done,
										 int32 total,
										 SPErr (*proc) (void *),
										 void *refCon);


// Change the current text in the progress bar.

typedef void (*Progress_ChangeProgressText) (const ASZString zs);


// Perform a task using the preview sniffing logic. This aborts if we encounter
// an event meeting the indicated conditions. selector should be one of the
// following:
//		"up"		-- Process until mouse down or key stroke
//		"down"		-- Process until mouse is released
//		"paused"	-- Process until mouse is moved or released
// Passing null will cause the code to choose between "up" and "paused"
// dependent on the current mouse state. All other strings result in an
// immediate error.

typedef SPErr (*Progress_DoPreviewTask) (const char *selector,
										SPErr (*proc) (void *),
					 					void *refCon);


// Run a task with the watch cursor up.

typedef SPErr (*Progress_DoWatchTask) (SPErr (*proc) (void *), void *refCon);


// Run a task without the watch cursor. This doesn't actually take the watch
// cursor down, but it will keep the watch from spinning.

typedef SPErr (*Progress_DoSuspendedWatchTask) (SPErr (*proc) (void *), void *refCon);

typedef void (*Progress_ContinueWatchCursor) (void);


//-------------------------------------------------------------------------
//	Progress suite version 1
//-------------------------------------------------------------------------

#define kPSProgressSuiteVersion1		1

typedef struct 
{
	Progress_DoProgress					DoProgress;
	Progress_DoTask						DoTask;
	Progress_DoSegmentTask				DoSegmentTask;
	Progress_ChangeProgressText			ChangeProgressText;
	Progress_DoPreviewTask				DoPreviewTask;
	Progress_DoWatchTask				DoWatchTask;
	Progress_DoSuspendedWatchTask		DoSuspendedWatchTask;
	Progress_ContinueWatchCursor		ContinueWatchCursor;

//	The following are taken from from the parameter block and are defined in PIGeneral.h:
	TestAbortProc						TestAbort;
	ProgressProc						UpdateProgress;
		
} PSProgressSuite1;

/******************************************************************************/

#ifdef __cplusplus
}
#endif


#endif	// PIProgressSuite
